import { createVNode as _createVNode } from "vue";
// Styles
import "./VLabel.css";

// Composables
import { makeComponentProps } from "../../composables/component.mjs";
import { makeThemeProps } from "../../composables/theme.mjs"; // Utilities
import { genericComponent, propsFactory, useRender } from "../../util/index.mjs";
export const makeVLabelProps = propsFactory({
  text: String,
  clickable: Boolean,
  ...makeComponentProps(),
  ...makeThemeProps()
}, 'VLabel');
export const VLabel = genericComponent()({
  name: 'VLabel',
  props: makeVLabelProps(),
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    useRender(() => _createVNode("label", {
      "class": ['v-label', {
        'v-label--clickable': props.clickable
      }, props.class],
      "style": props.style
    }, [props.text, slots.default?.()]));
    return {};
  }
});
//# sourceMappingURL=VLabel.mjs.map