import { resolveDirective as _resolveDirective, Fragment as _Fragment, createVNode as _createVNode, mergeProps as _mergeProps } from "vue";
// Styles
import "./VDatePicker.css";

// Components
import { makeVDatePickerControlsProps, VDatePickerControls } from "./VDatePickerControls.mjs";
import { VDatePickerHeader } from "./VDatePickerHeader.mjs";
import { makeVDatePickerMonthProps, VDatePickerMonth } from "./VDatePickerMonth.mjs";
import { makeVDatePickerYearsProps, VDatePickerYears } from "./VDatePickerYears.mjs";
import { VFadeTransition } from "../../components/transitions/index.mjs";
import { VBtn } from "../../components/VBtn/index.mjs";
import { VTextField } from "../../components/VTextField/index.mjs";
import { dateEmits, makeDateProps } from "../VDateInput/composables.mjs";
import { makeVPickerProps, VPicker } from "../VPicker/VPicker.mjs"; // Composables
import { createDatePicker } from "./composables.mjs";
import { useLocale } from "../../composables/locale.mjs";
import { useDate } from "../date/index.mjs"; // Utilities
import { computed, shallowRef, watch } from 'vue';
import { genericComponent, propsFactory, useRender } from "../../util/index.mjs"; // Types
export const makeVDatePickerProps = propsFactory({
  calendarIcon: {
    type: String,
    default: '$calendar'
  },
  keyboardIcon: {
    type: String,
    default: '$edit'
  },
  cancelText: {
    type: String,
    default: '$vuetify.datePicker.cancel'
  },
  okText: {
    type: String,
    default: '$vuetify.datePicker.ok'
  },
  inputText: {
    type: String,
    default: '$vuetify.datePicker.input.placeholder'
  },
  header: {
    type: String,
    default: '$vuetify.datePicker.header'
  },
  hideActions: Boolean,
  ...makeDateProps(),
  ...makeVDatePickerControlsProps(),
  ...makeVDatePickerMonthProps(),
  ...makeVDatePickerYearsProps(),
  ...makeVPickerProps({
    title: '$vuetify.datePicker.title'
  })
}, 'VDatePicker');
export const VDatePicker = genericComponent()({
  name: 'VDatePicker',
  props: makeVDatePickerProps(),
  emits: {
    'click:cancel': () => true,
    'click:save': () => true,
    ...dateEmits
  },
  setup(props, _ref) {
    let {
      emit,
      slots
    } = _ref;
    const adapter = useDate();
    const {
      t
    } = useLocale();
    const {
      model,
      displayDate,
      viewMode,
      inputMode
    } = createDatePicker(props);
    const isReversing = shallowRef(false);
    const inputModel = computed(() => model.value.length ? adapter.format(model.value[0], 'keyboardDate') : '');
    const title = computed(() => t(props.title));
    const header = computed(() => model.value.length ? adapter.format(model.value[0], 'normalDateWithWeekday') : t(props.header));
    const headerIcon = computed(() => inputMode.value === 'calendar' ? props.keyboardIcon : props.calendarIcon);
    const headerTransition = computed(() => `date-picker-header${isReversing.value ? '-reverse' : ''}-transition`);
    watch(inputModel, () => {
      const {
        isValid,
        date
      } = adapter;
      model.value = isValid(inputModel.value) ? [date(inputModel.value)] : [];
    });
    watch(model, (val, oldVal) => {
      if (props.hideActions) {
        emit('update:modelValue', val);
      }
      if (val[0] && oldVal[0]) {
        isReversing.value = adapter.isBefore(val[0], oldVal[0]);
      }
    });
    function onClickCancel() {
      emit('click:cancel');
    }
    function onClickSave() {
      emit('click:save');
      emit('update:modelValue', model.value);
    }
    function onClickAppend() {
      inputMode.value = inputMode.value === 'calendar' ? 'keyboard' : 'calendar';
    }
    const headerSlotProps = computed(() => ({
      header: header.value,
      appendIcon: headerIcon.value,
      transition: headerTransition.value,
      'onClick:append': onClickAppend
    }));
    useRender(() => {
      const [pickerProps] = VPicker.filterProps(props);
      const [datePickerControlsProps] = VDatePickerControls.filterProps(props);
      const [datePickerMonthProps] = VDatePickerMonth.filterProps(props);
      const [datePickerYearsProps] = VDatePickerYears.filterProps(props);
      return _createVNode(VPicker, _mergeProps(pickerProps, {
        "class": ['v-date-picker', props.class],
        "style": props.style,
        "title": title.value,
        "width": props.showWeek ? 408 : 360
      }), {
        header: () => slots.header?.(headerSlotProps.value) ?? _createVNode(VDatePickerHeader, _mergeProps({
          "key": "header"
        }, headerSlotProps.value), null),
        default: () => inputMode.value === 'calendar' ? _createVNode(_Fragment, null, [_createVNode(VDatePickerControls, _mergeProps(datePickerControlsProps, {
          "displayDate": displayDate.value,
          "onUpdate:displayDate": $event => displayDate.value = $event,
          "viewMode": viewMode.value,
          "onUpdate:viewMode": $event => viewMode.value = $event
        }), null), _createVNode(VFadeTransition, {
          "hideOnLeave": true
        }, {
          default: () => [viewMode.value === 'month' ? _createVNode(VDatePickerMonth, _mergeProps({
            "key": "date-picker-month"
          }, datePickerMonthProps, {
            "modelValue": model.value,
            "onUpdate:modelValue": $event => model.value = $event,
            "displayDate": displayDate.value,
            "onUpdate:displayDate": $event => displayDate.value = $event
          }), null) : _createVNode(VDatePickerYears, _mergeProps({
            "key": "date-picker-years"
          }, datePickerYearsProps, {
            "displayDate": displayDate.value,
            "onUpdate:displayDate": $event => displayDate.value = $event,
            "viewMode": viewMode.value,
            "onUpdate:viewMode": $event => viewMode.value = $event
          }), null)]
        })]) : _createVNode("div", {
          "class": "v-date-picker__input"
        }, [_createVNode(VTextField, {
          "modelValue": inputModel.value,
          "onUpdate:modelValue": $event => inputModel.value = $event,
          "label": t(props.inputText),
          "placeholder": "dd/mm/yyyy"
        }, null)]),
        actions: () => !props.hideActions ? _createVNode("div", null, [_createVNode(VBtn, {
          "variant": "text",
          "color": props.color,
          "onClick": onClickCancel,
          "text": t(props.cancelText)
        }, null), _createVNode(VBtn, {
          "variant": "text",
          "color": props.color,
          "onClick": onClickSave,
          "text": t(props.okText)
        }, null)]) : undefined
      });
    });
    return {};
  }
});
//# sourceMappingURL=VDatePicker.mjs.map