import { createVNode as _createVNode } from "vue";
// Styles
import "./VDatePickerYears.css";

// Components
import { VBtn } from "../../components/VBtn/index.mjs"; // Composables
import { useDate } from "../date/index.mjs"; // Utilities
import { computed, onMounted, ref } from 'vue';
import { convertToUnit, createRange, genericComponent, propsFactory, useRender } from "../../util/index.mjs";
export const makeVDatePickerYearsProps = propsFactory({
  color: String,
  min: Number,
  max: Number,
  height: [String, Number],
  displayDate: null
}, 'VDatePickerYears');
export const VDatePickerYears = genericComponent()({
  name: 'VDatePickerYears',
  props: makeVDatePickerYearsProps(),
  emits: {
    'update:displayDate': date => true,
    'update:viewMode': date => true
  },
  setup(props, _ref) {
    let {
      emit
    } = _ref;
    const adapter = useDate();
    const displayYear = computed(() => adapter.getYear(props.displayDate ?? new Date()));
    const years = computed(() => {
      const min = props.min ?? displayYear.value - 50 - 2;
      const max = props.max ?? displayYear.value + 50;
      return createRange(max - min, min);
    });
    const yearRef = ref();
    onMounted(() => {
      yearRef.value?.$el.scrollIntoView({
        block: 'center'
      });
    });
    useRender(() => _createVNode("div", {
      "class": "v-date-picker-years",
      "style": {
        height: convertToUnit(props.height)
      }
    }, [_createVNode("div", {
      "class": "v-date-picker-years__content"
    }, [years.value.map(year => _createVNode(VBtn, {
      "ref": year === displayYear.value ? yearRef : undefined,
      "variant": year === displayYear.value ? 'flat' : 'text',
      "rounded": "xl",
      "active": year === displayYear.value,
      "color": year === displayYear.value ? props.color : undefined,
      "onClick": () => {
        emit('update:displayDate', adapter.setYear(props.displayDate, year));
        emit('update:viewMode', 'month');
      }
    }, {
      default: () => [year]
    }))])]));
    return {};
  }
});
//# sourceMappingURL=VDatePickerYears.mjs.map