import * as vue from 'vue';
import { ComponentPropsOptions, ExtractPropTypes, PropType } from 'vue';

declare const block: readonly ["top", "bottom"];
declare const inline: readonly ["start", "end", "left", "right"];
type Tblock = typeof block[number];
type Tinline = typeof inline[number];
type Anchor = Tblock | Tinline | 'center' | 'center center' | `${Tblock} ${Tinline | 'center'}` | `${Tinline} ${Tblock | 'center'}`;

interface FilterPropsOptions<PropsOptions extends Readonly<ComponentPropsOptions>, Props = ExtractPropTypes<PropsOptions>> {
    filterProps<T extends Partial<Props>, U extends Exclude<keyof Props, Exclude<keyof Props, keyof T>>>(props: T): [yes: Partial<Pick<T, U>>, no: Omit<T, U>];
}

interface LoaderSlotProps {
    color: string | undefined;
    isActive: boolean;
}

declare const VDateCard: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: {
            transition?: NonNullable<string | boolean | (vue.TransitionProps & {
                component?: vue.Component | undefined;
            })> | {
                component: {
                    new (...args: any[]): {
                        $: vue.ComponentInternalInstance;
                        $data: {};
                        $props: {
                            origin?: string | undefined;
                            disabled?: boolean | undefined;
                            group?: boolean | undefined;
                            mode?: string | undefined;
                            hideOnLeave?: boolean | undefined;
                            leaveAbsolute?: boolean | undefined;
                            key?: string | number | symbol | undefined;
                            style?: unknown;
                            class?: unknown;
                            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                                default?: (() => vue.VNodeChild) | undefined;
                            };
                            ref?: vue.VNodeRef | undefined;
                            ref_for?: boolean | undefined;
                            ref_key?: string | undefined;
                            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                            'v-slots'?: {
                                default?: false | (() => vue.VNodeChild) | undefined;
                            } | undefined;
                            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                        };
                        $attrs: {
                            [x: string]: unknown;
                        };
                        $refs: {
                            [x: string]: unknown;
                        };
                        $slots: Readonly<{
                            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>[]) | undefined;
                        }>;
                        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                        $emit: (event: string, ...args: any[]) => void;
                        $el: any;
                        $options: vue.ComponentOptionsBase<{
                            origin: string | undefined;
                            disabled: boolean;
                            group: boolean;
                            mode: string | undefined;
                            hideOnLeave: boolean;
                            leaveAbsolute: boolean;
                        } & {} & {
                            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                                default?: (() => vue.VNodeChild) | undefined;
                            };
                            'v-slots'?: {
                                default?: false | (() => vue.VNodeChild) | undefined;
                            } | undefined;
                        } & {
                            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                            origin: string | undefined;
                            disabled: boolean;
                            group: boolean;
                            mode: string | undefined;
                            hideOnLeave: boolean;
                            leaveAbsolute: boolean;
                        }, {}, string, vue.SlotsType<Partial<{
                            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>[];
                        }>>> & {
                            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                            created?: ((() => void) | (() => void)[]) | undefined;
                            beforeMount?: ((() => void) | (() => void)[]) | undefined;
                            mounted?: ((() => void) | (() => void)[]) | undefined;
                            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                            updated?: ((() => void) | (() => void)[]) | undefined;
                            activated?: ((() => void) | (() => void)[]) | undefined;
                            deactivated?: ((() => void) | (() => void)[]) | undefined;
                            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                            destroyed?: ((() => void) | (() => void)[]) | undefined;
                            unmounted?: ((() => void) | (() => void)[]) | undefined;
                            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                        };
                        $forceUpdate: () => void;
                        $nextTick: typeof vue.nextTick;
                        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                    } & {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>> & {} & vue.ComponentCustomProperties & {};
                    __isFragment?: undefined;
                    __isTeleport?: undefined;
                    __isSuspense?: undefined;
                } & vue.ComponentOptionsBase<{
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                }, {}, string, vue.SlotsType<Partial<{
                    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[];
                }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                    disabled: BooleanConstructor;
                    group: BooleanConstructor;
                    hideOnLeave: BooleanConstructor;
                    leaveAbsolute: BooleanConstructor;
                    mode: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                    origin: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                }, vue.ExtractPropTypes<{
                    disabled: BooleanConstructor;
                    group: BooleanConstructor;
                    hideOnLeave: BooleanConstructor;
                    leaveAbsolute: BooleanConstructor;
                    mode: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                    origin: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                }>>;
                leaveAbsolute: boolean;
            } | undefined;
            inputMode?: "calendar" | "keyboard" | undefined;
            multiple?: boolean | undefined;
            range?: string | boolean | undefined;
            modelValue?: any[] | undefined;
            collapseIcon?: string | undefined;
            expandIcon?: string | undefined;
            nextIcon?: string | undefined;
            prevIcon?: string | undefined;
            hideActions?: boolean | undefined;
            viewMode?: "month" | "year" | undefined;
            showAdjacentMonths?: boolean | undefined;
            hideWeekdays?: boolean | undefined;
            showWeek?: boolean | undefined;
            cancelText?: string | undefined;
            okText?: string | undefined;
            max?: number | undefined;
            key?: string | number | symbol | undefined;
            height?: string | number | undefined;
            color?: string | undefined;
            style?: unknown;
            class?: unknown;
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
                prepend?: (() => vue.VNodeChild) | undefined;
                append?: (() => vue.VNodeChild) | undefined;
                title?: (() => vue.VNodeChild) | undefined;
                subtitle?: (() => vue.VNodeChild) | undefined;
                actions?: (() => vue.VNodeChild) | undefined;
                text?: (() => vue.VNodeChild) | undefined;
                loader?: ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
                image?: (() => vue.VNodeChild) | undefined;
                item?: (() => vue.VNodeChild) | undefined;
            };
            min?: number | undefined;
            format?: string | undefined;
            ref?: vue.VNodeRef | undefined;
            ref_for?: boolean | undefined;
            ref_key?: string | undefined;
            side?: string | undefined;
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
                prepend?: false | (() => vue.VNodeChild) | undefined;
                append?: false | (() => vue.VNodeChild) | undefined;
                title?: false | (() => vue.VNodeChild) | undefined;
                subtitle?: false | (() => vue.VNodeChild) | undefined;
                actions?: false | (() => vue.VNodeChild) | undefined;
                text?: false | (() => vue.VNodeChild) | undefined;
                loader?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
                image?: false | (() => vue.VNodeChild) | undefined;
                item?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:image"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
            "onUpdate:modelValue"?: ((value: any) => any) | undefined;
            "v-slot:loader"?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
            "v-slot:subtitle"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:item"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:actions"?: false | (() => vue.VNodeChild) | undefined;
            displayDate?: any;
            "onUpdate:displayDate"?: ((value: any) => any) | undefined;
            "onUpdate:inputMode"?: ((value: any) => any) | undefined;
            "onUpdate:viewMode"?: ((mode: "month" | "year") => any) | undefined;
            hoverDate?: any;
            onCancel?: (() => any) | undefined;
            onSave?: (() => any) | undefined;
        };
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            prepend?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            append?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            title?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            subtitle?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            actions?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            text?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            loader?: ((arg: LoaderSlotProps) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            image?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            item?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: ((event: "cancel") => void) & ((event: "update:modelValue", value: any) => void) & ((event: "update:inputMode", value: any) => void) & ((event: "update:displayDate", value: any) => void) & ((event: "update:viewMode", mode: "month" | "year") => void) & ((event: "save") => void);
        $el: any;
        $options: vue.ComponentOptionsBase<{
            transition: NonNullable<string | boolean | (vue.TransitionProps & {
                component?: vue.Component | undefined;
            })> | {
                component: {
                    new (...args: any[]): {
                        $: vue.ComponentInternalInstance;
                        $data: {};
                        $props: {
                            origin?: string | undefined;
                            disabled?: boolean | undefined;
                            group?: boolean | undefined;
                            mode?: string | undefined;
                            hideOnLeave?: boolean | undefined;
                            leaveAbsolute?: boolean | undefined;
                            key?: string | number | symbol | undefined;
                            style?: unknown;
                            class?: unknown;
                            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                                default?: (() => vue.VNodeChild) | undefined;
                            };
                            ref?: vue.VNodeRef | undefined;
                            ref_for?: boolean | undefined;
                            ref_key?: string | undefined;
                            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                            'v-slots'?: {
                                default?: false | (() => vue.VNodeChild) | undefined;
                            } | undefined;
                            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                        };
                        $attrs: {
                            [x: string]: unknown;
                        };
                        $refs: {
                            [x: string]: unknown;
                        };
                        $slots: Readonly<{
                            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>[]) | undefined;
                        }>;
                        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                        $emit: (event: string, ...args: any[]) => void;
                        $el: any;
                        $options: vue.ComponentOptionsBase<{
                            origin: string | undefined;
                            disabled: boolean;
                            group: boolean;
                            mode: string | undefined;
                            hideOnLeave: boolean;
                            leaveAbsolute: boolean;
                        } & {} & {
                            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                                default?: (() => vue.VNodeChild) | undefined;
                            };
                            'v-slots'?: {
                                default?: false | (() => vue.VNodeChild) | undefined;
                            } | undefined;
                        } & {
                            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                            origin: string | undefined;
                            disabled: boolean;
                            group: boolean;
                            mode: string | undefined;
                            hideOnLeave: boolean;
                            leaveAbsolute: boolean;
                        }, {}, string, vue.SlotsType<Partial<{
                            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>[];
                        }>>> & {
                            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                            created?: ((() => void) | (() => void)[]) | undefined;
                            beforeMount?: ((() => void) | (() => void)[]) | undefined;
                            mounted?: ((() => void) | (() => void)[]) | undefined;
                            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                            updated?: ((() => void) | (() => void)[]) | undefined;
                            activated?: ((() => void) | (() => void)[]) | undefined;
                            deactivated?: ((() => void) | (() => void)[]) | undefined;
                            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                            destroyed?: ((() => void) | (() => void)[]) | undefined;
                            unmounted?: ((() => void) | (() => void)[]) | undefined;
                            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                        };
                        $forceUpdate: () => void;
                        $nextTick: typeof vue.nextTick;
                        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                    } & {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>> & {} & vue.ComponentCustomProperties & {};
                    __isFragment?: undefined;
                    __isTeleport?: undefined;
                    __isSuspense?: undefined;
                } & vue.ComponentOptionsBase<{
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                }, {}, string, vue.SlotsType<Partial<{
                    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[];
                }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                    disabled: BooleanConstructor;
                    group: BooleanConstructor;
                    hideOnLeave: BooleanConstructor;
                    leaveAbsolute: BooleanConstructor;
                    mode: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                    origin: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                }, vue.ExtractPropTypes<{
                    disabled: BooleanConstructor;
                    group: BooleanConstructor;
                    hideOnLeave: BooleanConstructor;
                    leaveAbsolute: BooleanConstructor;
                    mode: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                    origin: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                }>>;
                leaveAbsolute: boolean;
            };
            inputMode: "calendar" | "keyboard";
            multiple: boolean;
            range: string | boolean;
            modelValue: any[];
            collapseIcon: string;
            expandIcon: string;
            nextIcon: string;
            prevIcon: string;
            hideActions: boolean;
            viewMode: "month" | "year";
            showAdjacentMonths: boolean;
            hideWeekdays: boolean;
            showWeek: boolean;
            cancelText: string;
            okText: string;
        } & {
            max?: number | undefined;
            height?: string | number | undefined;
            color?: string | undefined;
            min?: number | undefined;
            format?: string | undefined;
            side?: string | undefined;
            displayDate?: any;
            hoverDate?: any;
        } & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
                prepend?: (() => vue.VNodeChild) | undefined;
                append?: (() => vue.VNodeChild) | undefined;
                title?: (() => vue.VNodeChild) | undefined;
                subtitle?: (() => vue.VNodeChild) | undefined;
                actions?: (() => vue.VNodeChild) | undefined;
                text?: (() => vue.VNodeChild) | undefined;
                loader?: ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
                image?: (() => vue.VNodeChild) | undefined;
                item?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
                prepend?: false | (() => vue.VNodeChild) | undefined;
                append?: false | (() => vue.VNodeChild) | undefined;
                title?: false | (() => vue.VNodeChild) | undefined;
                subtitle?: false | (() => vue.VNodeChild) | undefined;
                actions?: false | (() => vue.VNodeChild) | undefined;
                text?: false | (() => vue.VNodeChild) | undefined;
                loader?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
                image?: false | (() => vue.VNodeChild) | undefined;
                item?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:subtitle"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:actions"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:loader"?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
            "v-slot:image"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:item"?: false | (() => vue.VNodeChild) | undefined;
        } & {
            "onUpdate:modelValue"?: ((value: any) => any) | undefined;
            "onUpdate:displayDate"?: ((value: any) => any) | undefined;
            "onUpdate:inputMode"?: ((value: any) => any) | undefined;
            "onUpdate:viewMode"?: ((mode: "month" | "year") => any) | undefined;
            onCancel?: (() => any) | undefined;
            onSave?: (() => any) | undefined;
        }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            save: () => true;
            cancel: () => true;
            'update:displayDate': (value: any) => true;
            'update:inputMode': (value: any) => true;
            'update:modelValue': (value: any) => true;
            'update:viewMode': (mode: 'month' | 'year') => true;
        }, string, {
            transition: NonNullable<string | boolean | (vue.TransitionProps & {
                component?: vue.Component | undefined;
            })> | {
                component: {
                    new (...args: any[]): {
                        $: vue.ComponentInternalInstance;
                        $data: {};
                        $props: {
                            origin?: string | undefined;
                            disabled?: boolean | undefined;
                            group?: boolean | undefined;
                            mode?: string | undefined;
                            hideOnLeave?: boolean | undefined;
                            leaveAbsolute?: boolean | undefined;
                            key?: string | number | symbol | undefined;
                            style?: unknown;
                            class?: unknown;
                            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                                default?: (() => vue.VNodeChild) | undefined;
                            };
                            ref?: vue.VNodeRef | undefined;
                            ref_for?: boolean | undefined;
                            ref_key?: string | undefined;
                            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                            'v-slots'?: {
                                default?: false | (() => vue.VNodeChild) | undefined;
                            } | undefined;
                            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>) => void)[] | undefined;
                        };
                        $attrs: {
                            [x: string]: unknown;
                        };
                        $refs: {
                            [x: string]: unknown;
                        };
                        $slots: Readonly<{
                            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>[]) | undefined;
                        }>;
                        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                        $emit: (event: string, ...args: any[]) => void;
                        $el: any;
                        $options: vue.ComponentOptionsBase<{
                            origin: string | undefined;
                            disabled: boolean;
                            group: boolean;
                            mode: string | undefined;
                            hideOnLeave: boolean;
                            leaveAbsolute: boolean;
                        } & {} & {
                            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                                default?: (() => vue.VNodeChild) | undefined;
                            };
                            'v-slots'?: {
                                default?: false | (() => vue.VNodeChild) | undefined;
                            } | undefined;
                        } & {
                            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                            origin: string | undefined;
                            disabled: boolean;
                            group: boolean;
                            mode: string | undefined;
                            hideOnLeave: boolean;
                            leaveAbsolute: boolean;
                        }, {}, string, vue.SlotsType<Partial<{
                            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                                [key: string]: any;
                            }>[];
                        }>>> & {
                            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                            created?: ((() => void) | (() => void)[]) | undefined;
                            beforeMount?: ((() => void) | (() => void)[]) | undefined;
                            mounted?: ((() => void) | (() => void)[]) | undefined;
                            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                            updated?: ((() => void) | (() => void)[]) | undefined;
                            activated?: ((() => void) | (() => void)[]) | undefined;
                            deactivated?: ((() => void) | (() => void)[]) | undefined;
                            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                            destroyed?: ((() => void) | (() => void)[]) | undefined;
                            unmounted?: ((() => void) | (() => void)[]) | undefined;
                            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                        };
                        $forceUpdate: () => void;
                        $nextTick: typeof vue.nextTick;
                        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                    } & {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>> & {} & vue.ComponentCustomProperties & {};
                    __isFragment?: undefined;
                    __isTeleport?: undefined;
                    __isSuspense?: undefined;
                } & vue.ComponentOptionsBase<{
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                }, {}, string, vue.SlotsType<Partial<{
                    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[];
                }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                    disabled: BooleanConstructor;
                    group: BooleanConstructor;
                    hideOnLeave: BooleanConstructor;
                    leaveAbsolute: BooleanConstructor;
                    mode: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                    origin: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                }, vue.ExtractPropTypes<{
                    disabled: BooleanConstructor;
                    group: BooleanConstructor;
                    hideOnLeave: BooleanConstructor;
                    leaveAbsolute: BooleanConstructor;
                    mode: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                    origin: {
                        type: PropType<string | undefined>;
                        default: string | undefined;
                    };
                }>>;
                leaveAbsolute: boolean;
            };
            inputMode: "calendar" | "keyboard";
            multiple: boolean;
            range: string | boolean;
            modelValue: any[];
            collapseIcon: string;
            expandIcon: string;
            nextIcon: string;
            prevIcon: string;
            hideActions: boolean;
            viewMode: "month" | "year";
            showAdjacentMonths: boolean;
            hideWeekdays: boolean;
            showWeek: boolean;
            cancelText: string;
            okText: string;
        }, {}, string, vue.SlotsType<Partial<{
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            prepend: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            append: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            title: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            subtitle: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            actions: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            text: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            loader: (arg: LoaderSlotProps) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            image: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            item: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {
        transition: NonNullable<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })> | {
            component: {
                new (...args: any[]): {
                    $: vue.ComponentInternalInstance;
                    $data: {};
                    $props: {
                        origin?: string | undefined;
                        disabled?: boolean | undefined;
                        group?: boolean | undefined;
                        mode?: string | undefined;
                        hideOnLeave?: boolean | undefined;
                        leaveAbsolute?: boolean | undefined;
                        key?: string | number | symbol | undefined;
                        style?: unknown;
                        class?: unknown;
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        ref?: vue.VNodeRef | undefined;
                        ref_for?: boolean | undefined;
                        ref_key?: string | undefined;
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                        onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                    };
                    $attrs: {
                        [x: string]: unknown;
                    };
                    $refs: {
                        [x: string]: unknown;
                    };
                    $slots: Readonly<{
                        default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[]) | undefined;
                    }>;
                    $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $emit: (event: string, ...args: any[]) => void;
                    $el: any;
                    $options: vue.ComponentOptionsBase<{
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    }, {}, string, vue.SlotsType<Partial<{
                        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[];
                    }>>> & {
                        beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                        created?: ((() => void) | (() => void)[]) | undefined;
                        beforeMount?: ((() => void) | (() => void)[]) | undefined;
                        mounted?: ((() => void) | (() => void)[]) | undefined;
                        beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                        updated?: ((() => void) | (() => void)[]) | undefined;
                        activated?: ((() => void) | (() => void)[]) | undefined;
                        deactivated?: ((() => void) | (() => void)[]) | undefined;
                        beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                        beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                        destroyed?: ((() => void) | (() => void)[]) | undefined;
                        unmounted?: ((() => void) | (() => void)[]) | undefined;
                        renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                    };
                    $forceUpdate: () => void;
                    $nextTick: typeof vue.nextTick;
                    $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                } & {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>> & {} & vue.ComponentCustomProperties & {};
                __isFragment?: undefined;
                __isTeleport?: undefined;
                __isSuspense?: undefined;
            } & vue.ComponentOptionsBase<{
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            }, {}, string, vue.SlotsType<Partial<{
                default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>[];
            }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }, vue.ExtractPropTypes<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }>>;
            leaveAbsolute: boolean;
        };
        inputMode: "calendar" | "keyboard";
        multiple: boolean;
        range: string | boolean;
        modelValue: any[];
        collapseIcon: string;
        expandIcon: string;
        nextIcon: string;
        prevIcon: string;
        hideActions: boolean;
        viewMode: "month" | "year";
        showAdjacentMonths: boolean;
        hideWeekdays: boolean;
        showWeek: boolean;
        cancelText: string;
        okText: string;
    } & {
        max?: number | undefined;
        height?: string | number | undefined;
        color?: string | undefined;
        min?: number | undefined;
        format?: string | undefined;
        side?: string | undefined;
        displayDate?: any;
        hoverDate?: any;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
            prepend?: (() => vue.VNodeChild) | undefined;
            append?: (() => vue.VNodeChild) | undefined;
            title?: (() => vue.VNodeChild) | undefined;
            subtitle?: (() => vue.VNodeChild) | undefined;
            actions?: (() => vue.VNodeChild) | undefined;
            text?: (() => vue.VNodeChild) | undefined;
            loader?: ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
            image?: (() => vue.VNodeChild) | undefined;
            item?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
            prepend?: false | (() => vue.VNodeChild) | undefined;
            append?: false | (() => vue.VNodeChild) | undefined;
            title?: false | (() => vue.VNodeChild) | undefined;
            subtitle?: false | (() => vue.VNodeChild) | undefined;
            actions?: false | (() => vue.VNodeChild) | undefined;
            text?: false | (() => vue.VNodeChild) | undefined;
            loader?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
            image?: false | (() => vue.VNodeChild) | undefined;
            item?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:subtitle"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:actions"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:loader"?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
        "v-slot:image"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:item"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:modelValue"?: ((value: any) => any) | undefined;
        "onUpdate:displayDate"?: ((value: any) => any) | undefined;
        "onUpdate:inputMode"?: ((value: any) => any) | undefined;
        "onUpdate:viewMode"?: ((mode: "month" | "year") => any) | undefined;
        onCancel?: (() => any) | undefined;
        onSave?: (() => any) | undefined;
    } & vue.ShallowUnwrapRef<{}> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    transition: NonNullable<string | boolean | (vue.TransitionProps & {
        component?: vue.Component | undefined;
    })> | {
        component: {
            new (...args: any[]): {
                $: vue.ComponentInternalInstance;
                $data: {};
                $props: {
                    origin?: string | undefined;
                    disabled?: boolean | undefined;
                    group?: boolean | undefined;
                    mode?: string | undefined;
                    hideOnLeave?: boolean | undefined;
                    leaveAbsolute?: boolean | undefined;
                    key?: string | number | symbol | undefined;
                    style?: unknown;
                    class?: unknown;
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    ref?: vue.VNodeRef | undefined;
                    ref_for?: boolean | undefined;
                    ref_key?: string | undefined;
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                    onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                };
                $attrs: {
                    [x: string]: unknown;
                };
                $refs: {
                    [x: string]: unknown;
                };
                $slots: Readonly<{
                    default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[]) | undefined;
                }>;
                $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                $emit: (event: string, ...args: any[]) => void;
                $el: any;
                $options: vue.ComponentOptionsBase<{
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                }, {}, string, vue.SlotsType<Partial<{
                    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[];
                }>>> & {
                    beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                    created?: ((() => void) | (() => void)[]) | undefined;
                    beforeMount?: ((() => void) | (() => void)[]) | undefined;
                    mounted?: ((() => void) | (() => void)[]) | undefined;
                    beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                    updated?: ((() => void) | (() => void)[]) | undefined;
                    activated?: ((() => void) | (() => void)[]) | undefined;
                    deactivated?: ((() => void) | (() => void)[]) | undefined;
                    beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                    beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                    destroyed?: ((() => void) | (() => void)[]) | undefined;
                    unmounted?: ((() => void) | (() => void)[]) | undefined;
                    renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                    renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                    errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                };
                $forceUpdate: () => void;
                $nextTick: typeof vue.nextTick;
                $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
            } & {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>> & {} & vue.ComponentCustomProperties & {};
            __isFragment?: undefined;
            __isTeleport?: undefined;
            __isSuspense?: undefined;
        } & vue.ComponentOptionsBase<{
            origin: string | undefined;
            disabled: boolean;
            group: boolean;
            mode: string | undefined;
            hideOnLeave: boolean;
            leaveAbsolute: boolean;
        } & {} & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
            origin: string | undefined;
            disabled: boolean;
            group: boolean;
            mode: string | undefined;
            hideOnLeave: boolean;
            leaveAbsolute: boolean;
        }, {}, string, vue.SlotsType<Partial<{
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
            disabled: BooleanConstructor;
            group: BooleanConstructor;
            hideOnLeave: BooleanConstructor;
            leaveAbsolute: BooleanConstructor;
            mode: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
            origin: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
        }, vue.ExtractPropTypes<{
            disabled: BooleanConstructor;
            group: BooleanConstructor;
            hideOnLeave: BooleanConstructor;
            leaveAbsolute: BooleanConstructor;
            mode: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
            origin: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
        }>>;
        leaveAbsolute: boolean;
    };
    inputMode: "calendar" | "keyboard";
    multiple: boolean;
    range: string | boolean;
    modelValue: any[];
    collapseIcon: string;
    expandIcon: string;
    nextIcon: string;
    prevIcon: string;
    hideActions: boolean;
    viewMode: "month" | "year";
    showAdjacentMonths: boolean;
    hideWeekdays: boolean;
    showWeek: boolean;
    cancelText: string;
    okText: string;
} & {
    max?: number | undefined;
    height?: string | number | undefined;
    color?: string | undefined;
    min?: number | undefined;
    format?: string | undefined;
    side?: string | undefined;
    displayDate?: any;
    hoverDate?: any;
} & {
    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
        default?: (() => vue.VNodeChild) | undefined;
        prepend?: (() => vue.VNodeChild) | undefined;
        append?: (() => vue.VNodeChild) | undefined;
        title?: (() => vue.VNodeChild) | undefined;
        subtitle?: (() => vue.VNodeChild) | undefined;
        actions?: (() => vue.VNodeChild) | undefined;
        text?: (() => vue.VNodeChild) | undefined;
        loader?: ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
        image?: (() => vue.VNodeChild) | undefined;
        item?: (() => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        default?: false | (() => vue.VNodeChild) | undefined;
        prepend?: false | (() => vue.VNodeChild) | undefined;
        append?: false | (() => vue.VNodeChild) | undefined;
        title?: false | (() => vue.VNodeChild) | undefined;
        subtitle?: false | (() => vue.VNodeChild) | undefined;
        actions?: false | (() => vue.VNodeChild) | undefined;
        text?: false | (() => vue.VNodeChild) | undefined;
        loader?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
        image?: false | (() => vue.VNodeChild) | undefined;
        item?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:subtitle"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:actions"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:loader"?: false | ((arg: LoaderSlotProps) => vue.VNodeChild) | undefined;
    "v-slot:image"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:item"?: false | (() => vue.VNodeChild) | undefined;
} & {
    "onUpdate:modelValue"?: ((value: any) => any) | undefined;
    "onUpdate:displayDate"?: ((value: any) => any) | undefined;
    "onUpdate:inputMode"?: ((value: any) => any) | undefined;
    "onUpdate:viewMode"?: ((mode: "month" | "year") => any) | undefined;
    onCancel?: (() => any) | undefined;
    onSave?: (() => any) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    save: () => true;
    cancel: () => true;
    'update:displayDate': (value: any) => true;
    'update:inputMode': (value: any) => true;
    'update:modelValue': (value: any) => true;
    'update:viewMode': (mode: 'month' | 'year') => true;
}, string, {
    transition: NonNullable<string | boolean | (vue.TransitionProps & {
        component?: vue.Component | undefined;
    })> | {
        component: {
            new (...args: any[]): {
                $: vue.ComponentInternalInstance;
                $data: {};
                $props: {
                    origin?: string | undefined;
                    disabled?: boolean | undefined;
                    group?: boolean | undefined;
                    mode?: string | undefined;
                    hideOnLeave?: boolean | undefined;
                    leaveAbsolute?: boolean | undefined;
                    key?: string | number | symbol | undefined;
                    style?: unknown;
                    class?: unknown;
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    ref?: vue.VNodeRef | undefined;
                    ref_for?: boolean | undefined;
                    ref_key?: string | undefined;
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                    onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                    onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>) => void)[] | undefined;
                };
                $attrs: {
                    [x: string]: unknown;
                };
                $refs: {
                    [x: string]: unknown;
                };
                $slots: Readonly<{
                    default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[]) | undefined;
                }>;
                $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                $emit: (event: string, ...args: any[]) => void;
                $el: any;
                $options: vue.ComponentOptionsBase<{
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                }, {}, string, vue.SlotsType<Partial<{
                    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>[];
                }>>> & {
                    beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                    created?: ((() => void) | (() => void)[]) | undefined;
                    beforeMount?: ((() => void) | (() => void)[]) | undefined;
                    mounted?: ((() => void) | (() => void)[]) | undefined;
                    beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                    updated?: ((() => void) | (() => void)[]) | undefined;
                    activated?: ((() => void) | (() => void)[]) | undefined;
                    deactivated?: ((() => void) | (() => void)[]) | undefined;
                    beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                    beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                    destroyed?: ((() => void) | (() => void)[]) | undefined;
                    unmounted?: ((() => void) | (() => void)[]) | undefined;
                    renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                    renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                    errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                };
                $forceUpdate: () => void;
                $nextTick: typeof vue.nextTick;
                $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
            } & {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>> & {} & vue.ComponentCustomProperties & {};
            __isFragment?: undefined;
            __isTeleport?: undefined;
            __isSuspense?: undefined;
        } & vue.ComponentOptionsBase<{
            origin: string | undefined;
            disabled: boolean;
            group: boolean;
            mode: string | undefined;
            hideOnLeave: boolean;
            leaveAbsolute: boolean;
        } & {} & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
            origin: string | undefined;
            disabled: boolean;
            group: boolean;
            mode: string | undefined;
            hideOnLeave: boolean;
            leaveAbsolute: boolean;
        }, {}, string, vue.SlotsType<Partial<{
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
            disabled: BooleanConstructor;
            group: BooleanConstructor;
            hideOnLeave: BooleanConstructor;
            leaveAbsolute: BooleanConstructor;
            mode: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
            origin: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
        }, vue.ExtractPropTypes<{
            disabled: BooleanConstructor;
            group: BooleanConstructor;
            hideOnLeave: BooleanConstructor;
            leaveAbsolute: BooleanConstructor;
            mode: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
            origin: {
                type: PropType<string | undefined>;
                default: string | undefined;
            };
        }>>;
        leaveAbsolute: boolean;
    };
    inputMode: "calendar" | "keyboard";
    multiple: boolean;
    range: string | boolean;
    modelValue: any[];
    collapseIcon: string;
    expandIcon: string;
    nextIcon: string;
    prevIcon: string;
    hideActions: boolean;
    viewMode: "month" | "year";
    showAdjacentMonths: boolean;
    hideWeekdays: boolean;
    showWeek: boolean;
    cancelText: string;
    okText: string;
}, {}, string, vue.SlotsType<Partial<{
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    prepend: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    append: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    title: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    subtitle: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    actions: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    text: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    loader: (arg: LoaderSlotProps) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    image: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    item: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    transition: Omit<{
        type: PropType<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })>;
        default: string;
        validator: (val: unknown) => boolean;
    }, "type" | "default"> & {
        type: PropType<NonNullable<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })> | {
            component: {
                new (...args: any[]): {
                    $: vue.ComponentInternalInstance;
                    $data: {};
                    $props: {
                        origin?: string | undefined;
                        disabled?: boolean | undefined;
                        group?: boolean | undefined;
                        mode?: string | undefined;
                        hideOnLeave?: boolean | undefined;
                        leaveAbsolute?: boolean | undefined;
                        key?: string | number | symbol | undefined;
                        style?: unknown;
                        class?: unknown;
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        ref?: vue.VNodeRef | undefined;
                        ref_for?: boolean | undefined;
                        ref_key?: string | undefined;
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                        onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                    };
                    $attrs: {
                        [x: string]: unknown;
                    };
                    $refs: {
                        [x: string]: unknown;
                    };
                    $slots: Readonly<{
                        default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[]) | undefined;
                    }>;
                    $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $emit: (event: string, ...args: any[]) => void;
                    $el: any;
                    $options: vue.ComponentOptionsBase<{
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    }, {}, string, vue.SlotsType<Partial<{
                        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[];
                    }>>> & {
                        beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                        created?: ((() => void) | (() => void)[]) | undefined;
                        beforeMount?: ((() => void) | (() => void)[]) | undefined;
                        mounted?: ((() => void) | (() => void)[]) | undefined;
                        beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                        updated?: ((() => void) | (() => void)[]) | undefined;
                        activated?: ((() => void) | (() => void)[]) | undefined;
                        deactivated?: ((() => void) | (() => void)[]) | undefined;
                        beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                        beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                        destroyed?: ((() => void) | (() => void)[]) | undefined;
                        unmounted?: ((() => void) | (() => void)[]) | undefined;
                        renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                    };
                    $forceUpdate: () => void;
                    $nextTick: typeof vue.nextTick;
                    $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                } & {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>> & {} & vue.ComponentCustomProperties & {};
                __isFragment?: undefined;
                __isTeleport?: undefined;
                __isSuspense?: undefined;
            } & vue.ComponentOptionsBase<{
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            }, {}, string, vue.SlotsType<Partial<{
                default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>[];
            }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }, vue.ExtractPropTypes<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }>>;
            leaveAbsolute: boolean;
        }>;
        default: NonNullable<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })> | {
            component: {
                new (...args: any[]): {
                    $: vue.ComponentInternalInstance;
                    $data: {};
                    $props: {
                        origin?: string | undefined;
                        disabled?: boolean | undefined;
                        group?: boolean | undefined;
                        mode?: string | undefined;
                        hideOnLeave?: boolean | undefined;
                        leaveAbsolute?: boolean | undefined;
                        key?: string | number | symbol | undefined;
                        style?: unknown;
                        class?: unknown;
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        ref?: vue.VNodeRef | undefined;
                        ref_for?: boolean | undefined;
                        ref_key?: string | undefined;
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                        onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                    };
                    $attrs: {
                        [x: string]: unknown;
                    };
                    $refs: {
                        [x: string]: unknown;
                    };
                    $slots: Readonly<{
                        default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[]) | undefined;
                    }>;
                    $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $emit: (event: string, ...args: any[]) => void;
                    $el: any;
                    $options: vue.ComponentOptionsBase<{
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    }, {}, string, vue.SlotsType<Partial<{
                        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[];
                    }>>> & {
                        beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                        created?: ((() => void) | (() => void)[]) | undefined;
                        beforeMount?: ((() => void) | (() => void)[]) | undefined;
                        mounted?: ((() => void) | (() => void)[]) | undefined;
                        beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                        updated?: ((() => void) | (() => void)[]) | undefined;
                        activated?: ((() => void) | (() => void)[]) | undefined;
                        deactivated?: ((() => void) | (() => void)[]) | undefined;
                        beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                        beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                        destroyed?: ((() => void) | (() => void)[]) | undefined;
                        unmounted?: ((() => void) | (() => void)[]) | undefined;
                        renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                    };
                    $forceUpdate: () => void;
                    $nextTick: typeof vue.nextTick;
                    $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                } & {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>> & {} & vue.ComponentCustomProperties & {};
                __isFragment?: undefined;
                __isTeleport?: undefined;
                __isSuspense?: undefined;
            } & vue.ComponentOptionsBase<{
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            }, {}, string, vue.SlotsType<Partial<{
                default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>[];
            }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }, vue.ExtractPropTypes<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }>>;
            leaveAbsolute: boolean;
        };
    };
    color: StringConstructor;
    min: NumberConstructor;
    max: NumberConstructor;
    height: (StringConstructor | NumberConstructor)[];
    displayDate: null;
    format: StringConstructor;
    modelValue: {
        type: PropType<any[]>;
        default: () => never[];
    };
    showAdjacentMonths: BooleanConstructor;
    hideWeekdays: BooleanConstructor;
    showWeek: BooleanConstructor;
    hoverDate: null;
    multiple: BooleanConstructor;
    side: {
        type: StringConstructor;
    };
    viewMode: {
        type: PropType<"month" | "year">;
        default: string;
    };
    nextIcon: {
        type: StringConstructor[];
        default: string;
    };
    prevIcon: {
        type: StringConstructor[];
        default: string;
    };
    expandIcon: {
        type: StringConstructor[];
        default: string;
    };
    collapseIcon: {
        type: StringConstructor[];
        default: string;
    };
    range: {
        default: boolean;
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
    cancelText: {
        type: StringConstructor;
        default: string;
    };
    okText: {
        type: StringConstructor;
        default: string;
    };
    inputMode: {
        type: PropType<"calendar" | "keyboard">;
        default: string;
    };
    hideActions: BooleanConstructor;
}, vue.ExtractPropTypes<{
    transition: Omit<{
        type: PropType<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })>;
        default: string;
        validator: (val: unknown) => boolean;
    }, "type" | "default"> & {
        type: PropType<NonNullable<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })> | {
            component: {
                new (...args: any[]): {
                    $: vue.ComponentInternalInstance;
                    $data: {};
                    $props: {
                        origin?: string | undefined;
                        disabled?: boolean | undefined;
                        group?: boolean | undefined;
                        mode?: string | undefined;
                        hideOnLeave?: boolean | undefined;
                        leaveAbsolute?: boolean | undefined;
                        key?: string | number | symbol | undefined;
                        style?: unknown;
                        class?: unknown;
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        ref?: vue.VNodeRef | undefined;
                        ref_for?: boolean | undefined;
                        ref_key?: string | undefined;
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                        onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                    };
                    $attrs: {
                        [x: string]: unknown;
                    };
                    $refs: {
                        [x: string]: unknown;
                    };
                    $slots: Readonly<{
                        default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[]) | undefined;
                    }>;
                    $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $emit: (event: string, ...args: any[]) => void;
                    $el: any;
                    $options: vue.ComponentOptionsBase<{
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    }, {}, string, vue.SlotsType<Partial<{
                        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[];
                    }>>> & {
                        beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                        created?: ((() => void) | (() => void)[]) | undefined;
                        beforeMount?: ((() => void) | (() => void)[]) | undefined;
                        mounted?: ((() => void) | (() => void)[]) | undefined;
                        beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                        updated?: ((() => void) | (() => void)[]) | undefined;
                        activated?: ((() => void) | (() => void)[]) | undefined;
                        deactivated?: ((() => void) | (() => void)[]) | undefined;
                        beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                        beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                        destroyed?: ((() => void) | (() => void)[]) | undefined;
                        unmounted?: ((() => void) | (() => void)[]) | undefined;
                        renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                    };
                    $forceUpdate: () => void;
                    $nextTick: typeof vue.nextTick;
                    $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                } & {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>> & {} & vue.ComponentCustomProperties & {};
                __isFragment?: undefined;
                __isTeleport?: undefined;
                __isSuspense?: undefined;
            } & vue.ComponentOptionsBase<{
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            }, {}, string, vue.SlotsType<Partial<{
                default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>[];
            }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }, vue.ExtractPropTypes<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }>>;
            leaveAbsolute: boolean;
        }>;
        default: NonNullable<string | boolean | (vue.TransitionProps & {
            component?: vue.Component | undefined;
        })> | {
            component: {
                new (...args: any[]): {
                    $: vue.ComponentInternalInstance;
                    $data: {};
                    $props: {
                        origin?: string | undefined;
                        disabled?: boolean | undefined;
                        group?: boolean | undefined;
                        mode?: string | undefined;
                        hideOnLeave?: boolean | undefined;
                        leaveAbsolute?: boolean | undefined;
                        key?: string | number | symbol | undefined;
                        style?: unknown;
                        class?: unknown;
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        ref?: vue.VNodeRef | undefined;
                        ref_for?: boolean | undefined;
                        ref_key?: string | undefined;
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                        onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                        onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>) => void)[] | undefined;
                    };
                    $attrs: {
                        [x: string]: unknown;
                    };
                    $refs: {
                        [x: string]: unknown;
                    };
                    $slots: Readonly<{
                        default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[]) | undefined;
                    }>;
                    $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
                    $emit: (event: string, ...args: any[]) => void;
                    $el: any;
                    $options: vue.ComponentOptionsBase<{
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    } & {} & {
                        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                            default?: (() => vue.VNodeChild) | undefined;
                        };
                        'v-slots'?: {
                            default?: false | (() => vue.VNodeChild) | undefined;
                        } | undefined;
                    } & {
                        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                    }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                        [key: string]: any;
                    }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                        origin: string | undefined;
                        disabled: boolean;
                        group: boolean;
                        mode: string | undefined;
                        hideOnLeave: boolean;
                        leaveAbsolute: boolean;
                    }, {}, string, vue.SlotsType<Partial<{
                        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                            [key: string]: any;
                        }>[];
                    }>>> & {
                        beforeCreate?: ((() => void) | (() => void)[]) | undefined;
                        created?: ((() => void) | (() => void)[]) | undefined;
                        beforeMount?: ((() => void) | (() => void)[]) | undefined;
                        mounted?: ((() => void) | (() => void)[]) | undefined;
                        beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
                        updated?: ((() => void) | (() => void)[]) | undefined;
                        activated?: ((() => void) | (() => void)[]) | undefined;
                        deactivated?: ((() => void) | (() => void)[]) | undefined;
                        beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
                        beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
                        destroyed?: ((() => void) | (() => void)[]) | undefined;
                        unmounted?: ((() => void) | (() => void)[]) | undefined;
                        renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
                        errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
                    };
                    $forceUpdate: () => void;
                    $nextTick: typeof vue.nextTick;
                    $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
                } & {
                    origin: string | undefined;
                    disabled: boolean;
                    group: boolean;
                    mode: string | undefined;
                    hideOnLeave: boolean;
                    leaveAbsolute: boolean;
                } & {} & {
                    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                        default?: (() => vue.VNodeChild) | undefined;
                    };
                    'v-slots'?: {
                        default?: false | (() => vue.VNodeChild) | undefined;
                    } | undefined;
                } & {
                    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
                } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>> & {} & vue.ComponentCustomProperties & {};
                __isFragment?: undefined;
                __isTeleport?: undefined;
                __isSuspense?: undefined;
            } & vue.ComponentOptionsBase<{
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            } & {} & {
                $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                    default?: (() => vue.VNodeChild) | undefined;
                };
                'v-slots'?: {
                    default?: false | (() => vue.VNodeChild) | undefined;
                } | undefined;
            } & {
                "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
                origin: string | undefined;
                disabled: boolean;
                group: boolean;
                mode: string | undefined;
                hideOnLeave: boolean;
                leaveAbsolute: boolean;
            }, {}, string, vue.SlotsType<Partial<{
                default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                    [key: string]: any;
                }>[];
            }>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }, vue.ExtractPropTypes<{
                disabled: BooleanConstructor;
                group: BooleanConstructor;
                hideOnLeave: BooleanConstructor;
                leaveAbsolute: BooleanConstructor;
                mode: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
                origin: {
                    type: PropType<string | undefined>;
                    default: string | undefined;
                };
            }>>;
            leaveAbsolute: boolean;
        };
    };
    color: StringConstructor;
    min: NumberConstructor;
    max: NumberConstructor;
    height: (StringConstructor | NumberConstructor)[];
    displayDate: null;
    format: StringConstructor;
    modelValue: {
        type: PropType<any[]>;
        default: () => never[];
    };
    showAdjacentMonths: BooleanConstructor;
    hideWeekdays: BooleanConstructor;
    showWeek: BooleanConstructor;
    hoverDate: null;
    multiple: BooleanConstructor;
    side: {
        type: StringConstructor;
    };
    viewMode: {
        type: PropType<"month" | "year">;
        default: string;
    };
    nextIcon: {
        type: StringConstructor[];
        default: string;
    };
    prevIcon: {
        type: StringConstructor[];
        default: string;
    };
    expandIcon: {
        type: StringConstructor[];
        default: string;
    };
    collapseIcon: {
        type: StringConstructor[];
        default: string;
    };
    range: {
        default: boolean;
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
    cancelText: {
        type: StringConstructor;
        default: string;
    };
    okText: {
        type: StringConstructor;
        default: string;
    };
    inputMode: {
        type: PropType<"calendar" | "keyboard">;
        default: string;
    };
    hideActions: BooleanConstructor;
}>>;
type VDateCard = InstanceType<typeof VDateCard>;

declare const VDatePicker: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: {
            header?: string | undefined;
            style?: vue.StyleValue | undefined;
            title?: string | undefined;
            inputMode?: "calendar" | "keyboard" | undefined;
            multiple?: boolean | undefined;
            landscape?: boolean | undefined;
            range?: string | boolean | undefined;
            tag?: string | undefined;
            rounded?: string | number | boolean | undefined;
            modelValue?: any[] | undefined;
            collapseIcon?: string | undefined;
            expandIcon?: string | undefined;
            nextIcon?: string | undefined;
            prevIcon?: string | undefined;
            hideActions?: boolean | undefined;
            viewMode?: "month" | "year" | undefined;
            showAdjacentMonths?: boolean | undefined;
            hideWeekdays?: boolean | undefined;
            showWeek?: boolean | undefined;
            cancelText?: string | undefined;
            okText?: string | undefined;
            calendarIcon?: string | undefined;
            keyboardIcon?: string | undefined;
            inputText?: string | undefined;
            max?: number | undefined;
            key?: string | number | symbol | undefined;
            location?: Anchor | undefined;
            height?: string | number | undefined;
            width?: string | number | undefined;
            border?: string | number | boolean | undefined;
            color?: string | undefined;
            maxHeight?: string | number | undefined;
            maxWidth?: string | number | undefined;
            minHeight?: string | number | undefined;
            minWidth?: string | number | undefined;
            position?: "fixed" | "absolute" | "static" | "relative" | "sticky" | undefined;
            class?: any;
            $children?: {} | vue.VNodeChild | {
                header?: ((arg: {
                    header: string;
                    appendIcon: string;
                    'onClick:append': () => void;
                }) => vue.VNodeChild) | undefined;
            };
            min?: number | undefined;
            elevation?: string | number | undefined;
            format?: string | undefined;
            ref?: vue.VNodeRef | undefined;
            ref_for?: boolean | undefined;
            ref_key?: string | undefined;
            side?: string | undefined;
            theme?: string | undefined;
            'v-slots'?: {
                header?: false | ((arg: {
                    header: string;
                    appendIcon: string;
                    'onClick:append': () => void;
                }) => vue.VNodeChild) | undefined;
            } | undefined;
            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
            "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
            "v-slot:header"?: false | ((arg: {
                header: string;
                appendIcon: string;
                'onClick:append': () => void;
            }) => vue.VNodeChild) | undefined;
            displayDate?: any;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:inputMode"?: ((inputMode: "calendar" | "keyboard") => any) | undefined;
            "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
            hoverDate?: any;
            "onClick:cancel"?: (() => any) | undefined;
            "onClick:save"?: (() => any) | undefined;
        };
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            header?: ((arg: {
                header: string;
                appendIcon: string;
                'onClick:append': () => void;
            }) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: ((event: "update:modelValue", date: readonly any[]) => void) & ((event: "update:focused", focused: boolean) => void) & ((event: "update:inputMode", inputMode: "calendar" | "keyboard") => void) & ((event: "update:displayDate", date: any) => void) & ((event: "update:viewMode", viewMode: "month" | "year") => void) & ((event: "click:cancel") => void) & ((event: "click:save") => void);
        $el: any;
        $options: vue.ComponentOptionsBase<{
            header: string;
            style: vue.StyleValue;
            title: string;
            inputMode: "calendar" | "keyboard";
            multiple: boolean;
            landscape: boolean;
            range: string | boolean;
            tag: string;
            modelValue: any[];
            collapseIcon: string;
            expandIcon: string;
            nextIcon: string;
            prevIcon: string;
            hideActions: boolean;
            viewMode: "month" | "year";
            showAdjacentMonths: boolean;
            hideWeekdays: boolean;
            showWeek: boolean;
            cancelText: string;
            okText: string;
            calendarIcon: string;
            keyboardIcon: string;
            inputText: string;
        } & {
            max?: number | undefined;
            location?: Anchor | undefined;
            height?: string | number | undefined;
            width?: string | number | undefined;
            border?: string | number | boolean | undefined;
            color?: string | undefined;
            maxHeight?: string | number | undefined;
            maxWidth?: string | number | undefined;
            minHeight?: string | number | undefined;
            minWidth?: string | number | undefined;
            position?: "fixed" | "absolute" | "static" | "relative" | "sticky" | undefined;
            class?: any;
            min?: number | undefined;
            elevation?: string | number | undefined;
            format?: string | undefined;
            side?: string | undefined;
            theme?: string | undefined;
            rounded?: string | number | boolean | undefined;
            displayDate?: any;
            hoverDate?: any;
        } & {
            $children?: {} | vue.VNodeChild | {
                header?: ((arg: {
                    header: string;
                    appendIcon: string;
                    'onClick:append': () => void;
                }) => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                header?: false | ((arg: {
                    header: string;
                    appendIcon: string;
                    'onClick:append': () => void;
                }) => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:header"?: false | ((arg: {
                header: string;
                appendIcon: string;
                'onClick:append': () => void;
            }) => vue.VNodeChild) | undefined;
        } & {
            "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
            "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:inputMode"?: ((inputMode: "calendar" | "keyboard") => any) | undefined;
            "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
            "onClick:cancel"?: (() => any) | undefined;
            "onClick:save"?: (() => any) | undefined;
        }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            'update:modelValue': (date: readonly any[]) => boolean;
            'update:displayDate': (date: any) => boolean;
            'update:focused': (focused: boolean) => boolean;
            'update:inputMode': (inputMode: "calendar" | "keyboard") => boolean;
            'update:viewMode': (viewMode: "month" | "year") => boolean;
            'click:cancel': () => true;
            'click:save': () => true;
        }, string, {
            header: string;
            style: vue.StyleValue;
            title: string;
            inputMode: "calendar" | "keyboard";
            multiple: boolean;
            landscape: boolean;
            range: string | boolean;
            tag: string;
            rounded: string | number | boolean;
            modelValue: any[];
            collapseIcon: string;
            expandIcon: string;
            nextIcon: string;
            prevIcon: string;
            hideActions: boolean;
            viewMode: "month" | "year";
            showAdjacentMonths: boolean;
            hideWeekdays: boolean;
            showWeek: boolean;
            cancelText: string;
            okText: string;
            calendarIcon: string;
            keyboardIcon: string;
            inputText: string;
        }, {}, string, vue.SlotsType<Partial<{
            header: (arg: {
                header: string;
                appendIcon: string;
                'onClick:append': () => void;
            }) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {
        header: string;
        style: vue.StyleValue;
        title: string;
        inputMode: "calendar" | "keyboard";
        multiple: boolean;
        landscape: boolean;
        range: string | boolean;
        tag: string;
        modelValue: any[];
        collapseIcon: string;
        expandIcon: string;
        nextIcon: string;
        prevIcon: string;
        hideActions: boolean;
        viewMode: "month" | "year";
        showAdjacentMonths: boolean;
        hideWeekdays: boolean;
        showWeek: boolean;
        cancelText: string;
        okText: string;
        calendarIcon: string;
        keyboardIcon: string;
        inputText: string;
    } & {
        max?: number | undefined;
        location?: Anchor | undefined;
        height?: string | number | undefined;
        width?: string | number | undefined;
        border?: string | number | boolean | undefined;
        color?: string | undefined;
        maxHeight?: string | number | undefined;
        maxWidth?: string | number | undefined;
        minHeight?: string | number | undefined;
        minWidth?: string | number | undefined;
        position?: "fixed" | "absolute" | "static" | "relative" | "sticky" | undefined;
        class?: any;
        min?: number | undefined;
        elevation?: string | number | undefined;
        format?: string | undefined;
        side?: string | undefined;
        theme?: string | undefined;
        rounded?: string | number | boolean | undefined;
        displayDate?: any;
        hoverDate?: any;
    } & {
        $children?: {} | vue.VNodeChild | {
            header?: ((arg: {
                header: string;
                appendIcon: string;
                'onClick:append': () => void;
            }) => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            header?: false | ((arg: {
                header: string;
                appendIcon: string;
                'onClick:append': () => void;
            }) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:header"?: false | ((arg: {
            header: string;
            appendIcon: string;
            'onClick:append': () => void;
        }) => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
        "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
        "onUpdate:displayDate"?: ((date: any) => any) | undefined;
        "onUpdate:inputMode"?: ((inputMode: "calendar" | "keyboard") => any) | undefined;
        "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
        "onClick:cancel"?: (() => any) | undefined;
        "onClick:save"?: (() => any) | undefined;
    } & vue.ShallowUnwrapRef<{}> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    header: string;
    style: vue.StyleValue;
    title: string;
    inputMode: "calendar" | "keyboard";
    multiple: boolean;
    landscape: boolean;
    range: string | boolean;
    tag: string;
    modelValue: any[];
    collapseIcon: string;
    expandIcon: string;
    nextIcon: string;
    prevIcon: string;
    hideActions: boolean;
    viewMode: "month" | "year";
    showAdjacentMonths: boolean;
    hideWeekdays: boolean;
    showWeek: boolean;
    cancelText: string;
    okText: string;
    calendarIcon: string;
    keyboardIcon: string;
    inputText: string;
} & {
    max?: number | undefined;
    location?: Anchor | undefined;
    height?: string | number | undefined;
    width?: string | number | undefined;
    border?: string | number | boolean | undefined;
    color?: string | undefined;
    maxHeight?: string | number | undefined;
    maxWidth?: string | number | undefined;
    minHeight?: string | number | undefined;
    minWidth?: string | number | undefined;
    position?: "fixed" | "absolute" | "static" | "relative" | "sticky" | undefined;
    class?: any;
    min?: number | undefined;
    elevation?: string | number | undefined;
    format?: string | undefined;
    side?: string | undefined;
    theme?: string | undefined;
    rounded?: string | number | boolean | undefined;
    displayDate?: any;
    hoverDate?: any;
} & {
    $children?: {} | vue.VNodeChild | {
        header?: ((arg: {
            header: string;
            appendIcon: string;
            'onClick:append': () => void;
        }) => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        header?: false | ((arg: {
            header: string;
            appendIcon: string;
            'onClick:append': () => void;
        }) => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:header"?: false | ((arg: {
        header: string;
        appendIcon: string;
        'onClick:append': () => void;
    }) => vue.VNodeChild) | undefined;
} & {
    "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
    "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
    "onUpdate:displayDate"?: ((date: any) => any) | undefined;
    "onUpdate:inputMode"?: ((inputMode: "calendar" | "keyboard") => any) | undefined;
    "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
    "onClick:cancel"?: (() => any) | undefined;
    "onClick:save"?: (() => any) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'update:modelValue': (date: readonly any[]) => boolean;
    'update:displayDate': (date: any) => boolean;
    'update:focused': (focused: boolean) => boolean;
    'update:inputMode': (inputMode: "calendar" | "keyboard") => boolean;
    'update:viewMode': (viewMode: "month" | "year") => boolean;
    'click:cancel': () => true;
    'click:save': () => true;
}, string, {
    header: string;
    style: vue.StyleValue;
    title: string;
    inputMode: "calendar" | "keyboard";
    multiple: boolean;
    landscape: boolean;
    range: string | boolean;
    tag: string;
    rounded: string | number | boolean;
    modelValue: any[];
    collapseIcon: string;
    expandIcon: string;
    nextIcon: string;
    prevIcon: string;
    hideActions: boolean;
    viewMode: "month" | "year";
    showAdjacentMonths: boolean;
    hideWeekdays: boolean;
    showWeek: boolean;
    cancelText: string;
    okText: string;
    calendarIcon: string;
    keyboardIcon: string;
    inputText: string;
}, {}, string, vue.SlotsType<Partial<{
    header: (arg: {
        header: string;
        appendIcon: string;
        'onClick:append': () => void;
    }) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    location: vue.PropType<Anchor>;
    height: (StringConstructor | NumberConstructor)[];
    width: (StringConstructor | NumberConstructor)[];
    border: (StringConstructor | BooleanConstructor | NumberConstructor)[];
    maxHeight: (StringConstructor | NumberConstructor)[];
    maxWidth: (StringConstructor | NumberConstructor)[];
    minHeight: (StringConstructor | NumberConstructor)[];
    minWidth: (StringConstructor | NumberConstructor)[];
    position: {
        type: vue.PropType<"fixed" | "absolute" | "static" | "relative" | "sticky">;
        validator: (v: any) => boolean;
    };
    style: {
        type: vue.PropType<vue.StyleValue>;
        default: null;
    };
    class: vue.PropType<any>;
    tag: {
        type: StringConstructor;
        default: string;
    };
    elevation: {
        type: (StringConstructor | NumberConstructor)[];
        validator(v: any): boolean;
    };
    theme: StringConstructor;
    rounded: {
        type: (StringConstructor | BooleanConstructor | NumberConstructor)[];
        default: undefined;
    };
    landscape: BooleanConstructor;
    title: {
        type: vue.PropType<string>;
        default: string;
    };
    color: StringConstructor;
    min: NumberConstructor;
    max: NumberConstructor;
    displayDate: null;
    format: StringConstructor;
    modelValue: {
        type: vue.PropType<any[]>;
        default: () => never[];
    };
    showAdjacentMonths: BooleanConstructor;
    hideWeekdays: BooleanConstructor;
    showWeek: BooleanConstructor;
    hoverDate: null;
    multiple: BooleanConstructor;
    side: {
        type: StringConstructor;
    };
    viewMode: {
        type: vue.PropType<"month" | "year">;
        default: string;
    };
    nextIcon: {
        type: StringConstructor[];
        default: string;
    };
    prevIcon: {
        type: StringConstructor[];
        default: string;
    };
    expandIcon: {
        type: StringConstructor[];
        default: string;
    };
    collapseIcon: {
        type: StringConstructor[];
        default: string;
    };
    range: {
        default: boolean;
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
    inputMode: {
        type: vue.PropType<"calendar" | "keyboard">;
        default: string;
    };
    calendarIcon: {
        type: StringConstructor;
        default: string;
    };
    keyboardIcon: {
        type: StringConstructor;
        default: string;
    };
    cancelText: {
        type: StringConstructor;
        default: string;
    };
    okText: {
        type: StringConstructor;
        default: string;
    };
    inputText: {
        type: StringConstructor;
        default: string;
    };
    header: {
        type: StringConstructor;
        default: string;
    };
    hideActions: BooleanConstructor;
}, vue.ExtractPropTypes<{
    location: vue.PropType<Anchor>;
    height: (StringConstructor | NumberConstructor)[];
    width: (StringConstructor | NumberConstructor)[];
    border: (StringConstructor | BooleanConstructor | NumberConstructor)[];
    maxHeight: (StringConstructor | NumberConstructor)[];
    maxWidth: (StringConstructor | NumberConstructor)[];
    minHeight: (StringConstructor | NumberConstructor)[];
    minWidth: (StringConstructor | NumberConstructor)[];
    position: {
        type: vue.PropType<"fixed" | "absolute" | "static" | "relative" | "sticky">;
        validator: (v: any) => boolean;
    };
    style: {
        type: vue.PropType<vue.StyleValue>;
        default: null;
    };
    class: vue.PropType<any>;
    tag: {
        type: StringConstructor;
        default: string;
    };
    elevation: {
        type: (StringConstructor | NumberConstructor)[];
        validator(v: any): boolean;
    };
    theme: StringConstructor;
    rounded: {
        type: (StringConstructor | BooleanConstructor | NumberConstructor)[];
        default: undefined;
    };
    landscape: BooleanConstructor;
    title: {
        type: vue.PropType<string>;
        default: string;
    };
    color: StringConstructor;
    min: NumberConstructor;
    max: NumberConstructor;
    displayDate: null;
    format: StringConstructor;
    modelValue: {
        type: vue.PropType<any[]>;
        default: () => never[];
    };
    showAdjacentMonths: BooleanConstructor;
    hideWeekdays: BooleanConstructor;
    showWeek: BooleanConstructor;
    hoverDate: null;
    multiple: BooleanConstructor;
    side: {
        type: StringConstructor;
    };
    viewMode: {
        type: vue.PropType<"month" | "year">;
        default: string;
    };
    nextIcon: {
        type: StringConstructor[];
        default: string;
    };
    prevIcon: {
        type: StringConstructor[];
        default: string;
    };
    expandIcon: {
        type: StringConstructor[];
        default: string;
    };
    collapseIcon: {
        type: StringConstructor[];
        default: string;
    };
    range: {
        default: boolean;
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
    inputMode: {
        type: vue.PropType<"calendar" | "keyboard">;
        default: string;
    };
    calendarIcon: {
        type: StringConstructor;
        default: string;
    };
    keyboardIcon: {
        type: StringConstructor;
        default: string;
    };
    cancelText: {
        type: StringConstructor;
        default: string;
    };
    okText: {
        type: StringConstructor;
        default: string;
    };
    inputText: {
        type: StringConstructor;
        default: string;
    };
    header: {
        type: StringConstructor;
        default: string;
    };
    hideActions: BooleanConstructor;
}>>;
type VDatePicker = InstanceType<typeof VDatePicker>;

declare const VDatePickerControls: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: {
            range?: string | boolean | undefined;
            collapseIcon?: string | undefined;
            expandIcon?: string | undefined;
            nextIcon?: string | undefined;
            prevIcon?: string | undefined;
            displayDate?: any;
            viewMode?: "month" | "year" | undefined;
            key?: string | number | symbol | undefined;
            style?: unknown;
            class?: unknown;
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            format?: string | undefined;
            ref?: vue.VNodeRef | undefined;
            ref_for?: boolean | undefined;
            ref_key?: string | undefined;
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
        };
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: ((event: "update:focused", focused: boolean) => void) & ((event: "update:displayDate", date: any) => void) & ((event: "update:viewMode", viewMode: "month" | "year") => void);
        $el: any;
        $options: vue.ComponentOptionsBase<{
            range: string | boolean;
            collapseIcon: string;
            expandIcon: string;
            nextIcon: string;
            prevIcon: string;
            displayDate: any;
            viewMode: "month" | "year";
        } & {
            format?: string | undefined;
        } & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        } & {
            "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
        }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            'update:focused': (focused: boolean) => boolean;
            'update:displayDate': (date: any) => boolean;
            'update:viewMode': (viewMode: "month" | "year") => boolean;
        }, string, {
            range: string | boolean;
            collapseIcon: string;
            expandIcon: string;
            nextIcon: string;
            prevIcon: string;
            displayDate: any;
            viewMode: "month" | "year";
        }, {}, string, vue.SlotsType<Partial<{
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {
        range: string | boolean;
        collapseIcon: string;
        expandIcon: string;
        nextIcon: string;
        prevIcon: string;
        displayDate: any;
        viewMode: "month" | "year";
    } & {
        format?: string | undefined;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
        "onUpdate:displayDate"?: ((date: any) => any) | undefined;
        "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
    } & vue.ShallowUnwrapRef<{}> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    range: string | boolean;
    collapseIcon: string;
    expandIcon: string;
    nextIcon: string;
    prevIcon: string;
    displayDate: any;
    viewMode: "month" | "year";
} & {
    format?: string | undefined;
} & {
    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
        default?: (() => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        default?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
} & {
    "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
    "onUpdate:displayDate"?: ((date: any) => any) | undefined;
    "onUpdate:viewMode"?: ((viewMode: "month" | "year") => any) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'update:focused': (focused: boolean) => boolean;
    'update:displayDate': (date: any) => boolean;
    'update:viewMode': (viewMode: "month" | "year") => boolean;
}, string, {
    range: string | boolean;
    collapseIcon: string;
    expandIcon: string;
    nextIcon: string;
    prevIcon: string;
    displayDate: any;
    viewMode: "month" | "year";
}, {}, string, vue.SlotsType<Partial<{
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    format: StringConstructor;
    displayDate: {
        type: vue.PropType<any>;
        default: null;
    };
    viewMode: {
        type: vue.PropType<"month" | "year">;
        default: string;
    };
    nextIcon: {
        type: StringConstructor[];
        default: string;
    };
    prevIcon: {
        type: StringConstructor[];
        default: string;
    };
    expandIcon: {
        type: StringConstructor[];
        default: string;
    };
    collapseIcon: {
        type: StringConstructor[];
        default: string;
    };
    range: {
        default: boolean;
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
}, vue.ExtractPropTypes<{
    format: StringConstructor;
    displayDate: {
        type: vue.PropType<any>;
        default: null;
    };
    viewMode: {
        type: vue.PropType<"month" | "year">;
        default: string;
    };
    nextIcon: {
        type: StringConstructor[];
        default: string;
    };
    prevIcon: {
        type: StringConstructor[];
        default: string;
    };
    expandIcon: {
        type: StringConstructor[];
        default: string;
    };
    collapseIcon: {
        type: StringConstructor[];
        default: string;
    };
    range: {
        default: boolean;
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
}>>;
type VDatePickerControls = InstanceType<typeof VDatePickerControls>;

declare const VDatePickerHeader: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: {
            key?: string | number | symbol | undefined;
            color?: string | undefined;
            transition?: string | undefined;
            header?: string | undefined;
            style?: unknown;
            class?: unknown;
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                prepend?: (() => vue.VNodeChild) | undefined;
                default?: (() => vue.VNodeChild) | undefined;
                append?: (() => vue.VNodeChild) | undefined;
            };
            ref?: vue.VNodeRef | undefined;
            ref_for?: boolean | undefined;
            ref_key?: string | undefined;
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            'v-slots'?: {
                prepend?: false | (() => vue.VNodeChild) | undefined;
                default?: false | (() => vue.VNodeChild) | undefined;
                append?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
            appendIcon?: string | undefined;
            "onClick:append"?: (() => any) | undefined;
        };
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            prepend?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            append?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: (event: "click:append") => void;
        $el: any;
        $options: vue.ComponentOptionsBase<{} & {
            color?: string | undefined;
            transition?: string | undefined;
            header?: string | undefined;
            appendIcon?: string | undefined;
        } & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                prepend?: (() => vue.VNodeChild) | undefined;
                default?: (() => vue.VNodeChild) | undefined;
                append?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                prepend?: false | (() => vue.VNodeChild) | undefined;
                default?: false | (() => vue.VNodeChild) | undefined;
                append?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
        } & {
            "onClick:append"?: (() => any) | undefined;
        }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            'click:append': () => true;
        }, string, {}, {}, string, vue.SlotsType<Partial<{
            prepend: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            append: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {} & {
        color?: string | undefined;
        transition?: string | undefined;
        header?: string | undefined;
        appendIcon?: string | undefined;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            prepend?: (() => vue.VNodeChild) | undefined;
            default?: (() => vue.VNodeChild) | undefined;
            append?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            prepend?: false | (() => vue.VNodeChild) | undefined;
            default?: false | (() => vue.VNodeChild) | undefined;
            append?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onClick:append"?: (() => any) | undefined;
    } & vue.ShallowUnwrapRef<{}> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{} & {
    color?: string | undefined;
    transition?: string | undefined;
    header?: string | undefined;
    appendIcon?: string | undefined;
} & {
    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
        prepend?: (() => vue.VNodeChild) | undefined;
        default?: (() => vue.VNodeChild) | undefined;
        append?: (() => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        prepend?: false | (() => vue.VNodeChild) | undefined;
        default?: false | (() => vue.VNodeChild) | undefined;
        append?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:prepend"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:append"?: false | (() => vue.VNodeChild) | undefined;
} & {
    "onClick:append"?: (() => any) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'click:append': () => true;
}, string, {}, {}, string, vue.SlotsType<Partial<{
    prepend: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    append: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    appendIcon: StringConstructor;
    color: StringConstructor;
    header: StringConstructor;
    transition: StringConstructor;
}, vue.ExtractPropTypes<{
    appendIcon: StringConstructor;
    color: StringConstructor;
    header: StringConstructor;
    transition: StringConstructor;
}>>;
type VDatePickerHeader = InstanceType<typeof VDatePickerHeader>;

declare const VDatePickerMonth: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: {
            color?: string | undefined;
            multiple?: boolean | undefined;
            modelValue?: any[] | undefined;
            displayDate?: any;
            showAdjacentMonths?: boolean | undefined;
            hideWeekdays?: boolean | undefined;
            showWeek?: boolean | undefined;
            key?: string | number | symbol | undefined;
            style?: unknown;
            class?: unknown;
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            format?: string | undefined;
            ref?: vue.VNodeRef | undefined;
            ref_for?: boolean | undefined;
            ref_key?: string | undefined;
            side?: string | undefined;
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
            "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            hoverDate?: any;
            "onUpdate:hoverDate"?: ((date: any) => any) | undefined;
        };
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: ((event: "update:modelValue", date: readonly any[]) => void) & ((event: "update:focused", focused: boolean) => void) & ((event: "update:displayDate", date: any) => void) & ((event: "update:hoverDate", date: any) => void);
        $el: any;
        $options: vue.ComponentOptionsBase<{
            color: string;
            multiple: boolean;
            modelValue: any[];
            displayDate: any;
            showAdjacentMonths: boolean;
            hideWeekdays: boolean;
            showWeek: boolean;
        } & {
            format?: string | undefined;
            side?: string | undefined;
            hoverDate?: any;
        } & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        } & {
            "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
            "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:hoverDate"?: ((date: any) => any) | undefined;
        }, () => JSX.Element, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            'update:hoverDate': (date: any) => true;
            'update:modelValue': (date: readonly any[]) => boolean;
            'update:focused': (focused: boolean) => boolean;
            'update:displayDate': (date: any) => boolean;
        }, string, {
            color: string;
            multiple: boolean;
            modelValue: any[];
            displayDate: any;
            showAdjacentMonths: boolean;
            hideWeekdays: boolean;
            showWeek: boolean;
        }, {}, string, vue.SlotsType<Partial<{
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {
        color: string;
        multiple: boolean;
        modelValue: any[];
        displayDate: any;
        showAdjacentMonths: boolean;
        hideWeekdays: boolean;
        showWeek: boolean;
    } & {
        format?: string | undefined;
        side?: string | undefined;
        hoverDate?: any;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
        "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
        "onUpdate:displayDate"?: ((date: any) => any) | undefined;
        "onUpdate:hoverDate"?: ((date: any) => any) | undefined;
    } & vue.ShallowUnwrapRef<() => JSX.Element> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    color: string;
    multiple: boolean;
    modelValue: any[];
    displayDate: any;
    showAdjacentMonths: boolean;
    hideWeekdays: boolean;
    showWeek: boolean;
} & {
    format?: string | undefined;
    side?: string | undefined;
    hoverDate?: any;
} & {
    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
        default?: (() => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        default?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
} & {
    "onUpdate:modelValue"?: ((date: readonly any[]) => any) | undefined;
    "onUpdate:focused"?: ((focused: boolean) => any) | undefined;
    "onUpdate:displayDate"?: ((date: any) => any) | undefined;
    "onUpdate:hoverDate"?: ((date: any) => any) | undefined;
}, () => JSX.Element, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'update:hoverDate': (date: any) => true;
    'update:modelValue': (date: readonly any[]) => boolean;
    'update:focused': (focused: boolean) => boolean;
    'update:displayDate': (date: any) => boolean;
}, string, {
    color: string;
    multiple: boolean;
    modelValue: any[];
    displayDate: any;
    showAdjacentMonths: boolean;
    hideWeekdays: boolean;
    showWeek: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    format: StringConstructor;
    modelValue: {
        type: vue.PropType<any[]>;
        default: () => never[];
    };
    displayDate: {
        type: vue.PropType<any>;
        default: null;
    };
    color: {
        type: vue.PropType<string>;
        default: string;
    };
    showAdjacentMonths: BooleanConstructor;
    hideWeekdays: BooleanConstructor;
    showWeek: BooleanConstructor;
    hoverDate: null;
    multiple: BooleanConstructor;
    side: {
        type: StringConstructor;
    };
}, vue.ExtractPropTypes<{
    format: StringConstructor;
    modelValue: {
        type: vue.PropType<any[]>;
        default: () => never[];
    };
    displayDate: {
        type: vue.PropType<any>;
        default: null;
    };
    color: {
        type: vue.PropType<string>;
        default: string;
    };
    showAdjacentMonths: BooleanConstructor;
    hideWeekdays: BooleanConstructor;
    showWeek: BooleanConstructor;
    hoverDate: null;
    multiple: BooleanConstructor;
    side: {
        type: StringConstructor;
    };
}>>;
type VDatePickerMonth = InstanceType<typeof VDatePickerMonth>;

declare const VDatePickerYears: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: {
            max?: number | undefined;
            key?: string | number | symbol | undefined;
            height?: string | number | undefined;
            color?: string | undefined;
            style?: unknown;
            class?: unknown;
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            min?: number | undefined;
            ref?: vue.VNodeRef | undefined;
            ref_for?: boolean | undefined;
            ref_key?: string | undefined;
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
            onVnodeBeforeMount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeMounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUpdate?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUpdated?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>, oldVNode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeBeforeUnmount?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            onVnodeUnmounted?: ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void) | ((vnode: vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>) => void)[] | undefined;
            displayDate?: any;
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:viewMode"?: ((date: any) => any) | undefined;
        };
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            default?: (() => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: ((event: "update:displayDate", date: any) => void) & ((event: "update:viewMode", date: any) => void);
        $el: any;
        $options: vue.ComponentOptionsBase<{} & {
            max?: number | undefined;
            height?: string | number | undefined;
            color?: string | undefined;
            min?: number | undefined;
            displayDate?: any;
        } & {
            $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
                default?: (() => vue.VNodeChild) | undefined;
            };
            'v-slots'?: {
                default?: false | (() => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        } & {
            "onUpdate:displayDate"?: ((date: any) => any) | undefined;
            "onUpdate:viewMode"?: ((date: any) => any) | undefined;
        }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            'update:displayDate': (date: any) => true;
            'update:viewMode': (date: any) => true;
        }, string, {}, {}, string, vue.SlotsType<Partial<{
            default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {} & {
        max?: number | undefined;
        height?: string | number | undefined;
        color?: string | undefined;
        min?: number | undefined;
        displayDate?: any;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:displayDate"?: ((date: any) => any) | undefined;
        "onUpdate:viewMode"?: ((date: any) => any) | undefined;
    } & vue.ShallowUnwrapRef<{}> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{} & {
    max?: number | undefined;
    height?: string | number | undefined;
    color?: string | undefined;
    min?: number | undefined;
    displayDate?: any;
} & {
    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
        default?: (() => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        default?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
} & {
    "onUpdate:displayDate"?: ((date: any) => any) | undefined;
    "onUpdate:viewMode"?: ((date: any) => any) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'update:displayDate': (date: any) => true;
    'update:viewMode': (date: any) => true;
}, string, {}, {}, string, vue.SlotsType<Partial<{
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    color: StringConstructor;
    min: NumberConstructor;
    max: NumberConstructor;
    height: (StringConstructor | NumberConstructor)[];
    displayDate: null;
}, vue.ExtractPropTypes<{
    color: StringConstructor;
    min: NumberConstructor;
    max: NumberConstructor;
    height: (StringConstructor | NumberConstructor)[];
    displayDate: null;
}>>;
type VDatePickerYears = InstanceType<typeof VDatePickerYears>;

export { VDateCard, VDatePicker, VDatePickerControls, VDatePickerHeader, VDatePickerMonth, VDatePickerYears };
