import { mergeProps as _mergeProps, createVNode as _createVNode } from "vue";
// Styles
import "./VPicker.css";

// Components
import { VPickerTitle } from "./VPickerTitle.mjs";
import { makeVSheetProps, VSheet } from "../../components/VSheet/VSheet.mjs"; // Utilities
import { genericComponent, omit, propsFactory, useRender } from "../../util/index.mjs"; // Types
export const makeVPickerProps = propsFactory({
  landscape: Boolean,
  title: String,
  ...omit(makeVSheetProps(), ['color'])
}, 'VPicker');
export const VPicker = genericComponent()({
  name: 'VPicker',
  props: makeVPickerProps(),
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    useRender(() => {
      const [sheetProps] = VSheet.filterProps(props);
      const hasTitle = !!(props.title || slots.title);
      return _createVNode(VSheet, _mergeProps(sheetProps, {
        "class": ['v-picker', {
          'v-picker--landscape': props.landscape,
          'v-picker--with-actions': !!slots.actions
        }, props.class],
        "style": props.style
      }), {
        default: () => [hasTitle && _createVNode(VPickerTitle, {
          "key": "picker-title"
        }, {
          default: () => [slots.title?.() ?? props.title]
        }), slots.header && _createVNode("div", {
          "class": "v-picker__header"
        }, [slots.header()]), _createVNode("div", {
          "class": "v-picker__body"
        }, [slots.default?.()]), slots.actions?.()[0]?.children && _createVNode("div", {
          "class": "v-picker__actions"
        }, [slots.actions()])]
      });
    });
    return {};
  }
});
//# sourceMappingURL=VPicker.mjs.map