import { mergeProps as _mergeProps, resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
// Components
import { VListGroup } from "./VListGroup.mjs";
import { VListItem } from "./VListItem.mjs";
import { VListSubheader } from "./VListSubheader.mjs";
import { VDivider } from "../VDivider/index.mjs"; // Utilities
import { createList } from "./list.mjs";
import { genericComponent, propsFactory } from "../../util/index.mjs"; // Types
export const makeVListChildrenProps = propsFactory({
  items: Array
}, 'VListChildren');
export const VListChildren = genericComponent()({
  name: 'VListChildren',
  props: makeVListChildrenProps(),
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    createList();
    return () => slots.default?.() ?? props.items?.map(_ref2 => {
      let {
        children,
        props: itemProps,
        type,
        raw: item
      } = _ref2;
      if (type === 'divider') {
        return slots.divider?.({
          props: itemProps
        }) ?? _createVNode(VDivider, itemProps, null);
      }
      if (type === 'subheader') {
        return slots.subheader?.({
          props: itemProps
        }) ?? _createVNode(VListSubheader, itemProps, null);
      }
      const slotsWithItem = {
        subtitle: slots.subtitle ? slotProps => slots.subtitle?.({
          ...slotProps,
          item
        }) : undefined,
        prepend: slots.prepend ? slotProps => slots.prepend?.({
          ...slotProps,
          item
        }) : undefined,
        append: slots.append ? slotProps => slots.append?.({
          ...slotProps,
          item
        }) : undefined,
        title: slots.title ? slotProps => slots.title?.({
          ...slotProps,
          item
        }) : undefined
      };
      const [listGroupProps, _1] = VListGroup.filterProps(itemProps);
      return children ? _createVNode(VListGroup, _mergeProps({
        "value": itemProps?.value
      }, listGroupProps), {
        activator: _ref3 => {
          let {
            props: activatorProps
          } = _ref3;
          return slots.header ? slots.header({
            props: {
              ...itemProps,
              ...activatorProps
            }
          }) : _createVNode(VListItem, _mergeProps(itemProps, activatorProps), slotsWithItem);
        },
        default: () => _createVNode(VListChildren, {
          "items": children
        }, slots)
      }) : slots.item ? slots.item({
        props: itemProps
      }) : _createVNode(VListItem, itemProps, slotsWithItem);
    });
  }
});
//# sourceMappingURL=VListChildren.mjs.map